/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.TreeMap;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.IPos;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.SubGuiColorSelector;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailability;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.data.Zone3D;

public class GuiBoundarySetting
extends GuiNPCInterface
implements ICustomScrollListener,
ITextfieldListener,
ISubGuiListener {
    private final int regID;
    private final TreeMap<Integer, String> dataRegions = new TreeMap();
    private final TreeMap<Integer, String> dataPoints = new TreeMap();
    private GuiCustomScroll regions;
    private GuiCustomScroll points;
    private Point point;
    private Zone3D region;

    public GuiBoundarySetting(int idReg, int idPoint) {
        this.setBackground("bgfilled.png");
        this.xSize = 405;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.regID = idReg;
        this.region = (Zone3D)BorderController.getInstance().getRegion(idReg);
        if (this.region != null && this.region.points.containsKey(idPoint)) {
            this.point = this.region.points.get(idPoint);
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                if (this.region == null) {
                    return;
                }
                this.setSubGui(new SubGuiColorSelector(this.region.color));
                return;
            }
            case 1: {
                if (this.region == null) {
                    return;
                }
                this.setSubGui(new SubGuiNpcAvailability(this.region.availability, this));
                return;
            }
            case 2: {
                if (this.region == null) {
                    return;
                }
                Client.sendData(EnumPacketServer.RegionData, 1, this.region.getId());
                this.region = null;
                this.point = null;
                break;
            }
            case 3: {
                this.region.offset(-1, 0, 0);
                break;
            }
            case 4: {
                this.region.offset(1, 0, 0);
                break;
            }
            case 5: {
                this.region.offset(0, 0, -1);
                break;
            }
            case 6: {
                this.region.offset(0, 0, 1);
                break;
            }
            case 7: {
                this.region.offset(0, -1, 0);
                break;
            }
            case 8: {
                this.region.offset(0, 1, 0);
                break;
            }
            case 10: {
                if (this.region == null || this.point == null) {
                    return;
                }
                TreeMap<Integer, Point> map = new TreeMap<Integer, Point>();
                int i = 0;
                for (int pos : this.region.points.keySet()) {
                    Point p = this.region.points.get(pos);
                    if (p != this.point && (p.x != this.point.x || p.y != this.point.y)) continue;
                    i = pos;
                    break;
                }
                int j = 0;
                for (int pos : this.region.points.keySet()) {
                    if (pos == i) continue;
                    if (pos + 1 == i) {
                        map.put(j++, this.point);
                    }
                    Point p = this.region.points.get(pos);
                    map.put(j++, p);
                }
                this.region.points.clear();
                this.region.points.putAll(map);
                break;
            }
            case 11: {
                if (this.region == null || this.point == null) {
                    return;
                }
                TreeMap<Integer, Point> map = new TreeMap<Integer, Point>();
                int i = 0;
                for (int pos : this.region.points.keySet()) {
                    Point p = this.region.points.get(pos);
                    if (p != this.point && (p.x != this.point.x || p.y != this.point.y)) continue;
                    i = pos;
                    break;
                }
                int j = 0;
                for (int pos : this.region.points.keySet()) {
                    if (pos == i) continue;
                    Point p = this.region.points.get(pos);
                    map.put(j++, p);
                    if (pos - 1 != i) continue;
                    map.put(j++, this.point);
                }
                this.region.points.clear();
                this.region.points.putAll(map);
                break;
            }
            case 12: {
                if (this.point == null) {
                    return;
                }
                --this.point.x;
                break;
            }
            case 13: {
                if (this.point == null) {
                    return;
                }
                ++this.point.x;
                break;
            }
            case 14: {
                if (this.point == null) {
                    return;
                }
                --this.point.y;
                break;
            }
            case 15: {
                if (this.point == null) {
                    return;
                }
                ++this.point.y;
                break;
            }
            case 18: {
                if (this.region == null) {
                    return;
                }
                this.region.y[1] = this.region.y[1] + 1;
                break;
            }
            case 19: {
                if (this.region == null) {
                    return;
                }
                this.region.y[1] = this.region.y[1] - 1;
                break;
            }
            case 20: {
                if (this.region == null) {
                    return;
                }
                this.region.y[0] = this.region.y[0] + 1;
                break;
            }
            case 21: {
                if (this.region == null) {
                    return;
                }
                this.region.y[0] = this.region.y[0] - 1;
                break;
            }
            case 24: {
                if (this.region == null) {
                    return;
                }
                if (this.point != null) {
                    Client.sendData(EnumPacketServer.TeleportTo, this.region.dimensionID, this.point.x, this.region.y[0] + (this.region.y[1] - this.region.y[0]) / 2, this.point.y);
                    return;
                }
                IPos pos = this.region.getCenter();
                Client.sendData(EnumPacketServer.TeleportTo, this.region.dimensionID, pos.getX(), pos.getY(), pos.getZ());
                return;
            }
            case 25: {
                if (this.region == null) {
                    return;
                }
                this.region.keepOut = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 26: {
                if (this.region == null) {
                    return;
                }
                this.region.showInClient = ((GuiNpcCheckBox)button).isSelected();
            }
        }
        this.func_73866_w_();
    }

    public static void drawLine(double left, double top, double right, double bottom, int color, float wLine) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)wLine);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(left, top, 0.0).func_181675_d();
        buffer.func_181662_b(right, bottom, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private void drawRegion(int work, double mu, double mv, double su, double sv, double sy) {
        double v1;
        double v0;
        if (this.region == null) {
            return;
        }
        for (int i = -1; i < this.region.points.size() - 1; ++i) {
            Point p0 = i == -1 ? this.region.points.get(this.region.points.size() - 1) : this.region.points.get(i);
            Point p1 = this.region.points.get(i + 1);
            if (p0 == null || p1 == null) continue;
            double u0 = ((double)p0.x - mu) * su;
            v0 = ((double)p0.y - mv) * sv;
            double u1 = ((double)p1.x - mu) * su;
            v1 = ((double)p1.y - mv) * sv;
            GuiBoundarySetting.drawLine(u0, v0, u1, v1, -16776961, 2.0f);
        }
        v0 = (double)Math.min(this.region.y[1], 255) * sy;
        v1 = (double)Math.max(this.region.y[0], 0) * sy;
        GuiBoundarySetting.drawLine(work + 12, v0, work + 13, v1, -16776961, 2.0f);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int hz;
        int hx;
        if (this.background != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)1.0f);
            GlStateManager.func_179152_a((float)this.bgScale, (float)this.bgScale, (float)this.bgScale);
            this.field_146297_k.func_110434_K().func_110577_a(this.background);
            if (this.xSize > 256) {
                this.func_73729_b(0, this.ySize - 1, 0, 252, 250, 4);
                this.func_73729_b(250, this.ySize - 1, 256 - (this.xSize - 250), 252, this.xSize - 250, 4);
            }
            GlStateManager.func_179121_F();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.subgui != null) {
            return;
        }
        int side = 160;
        int work = side - 12;
        int wu = this.guiLeft + 131;
        int wv = this.guiTop + 18;
        String ht = "";
        if (this.isMouseHover(mouseX, mouseY, wu, wv, side - 2, side)) {
            ht = "region.hover.work.0";
        } else if (this.isMouseHover(mouseX, mouseY, wu + side - 2, wv, 12, side)) {
            ht = "region.hover.work.1";
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)wu, (float)wv, (float)0.5f);
        int color = new Color(-1610612736).getRGB();
        Gui.func_73734_a((int)0, (int)0, (int)(side + 12), (int)side, (int)color);
        Gui.func_73734_a((int)6, (int)6, (int)(side - 6), (int)(side - 6), (int)color);
        Gui.func_73734_a((int)(side - 2), (int)6, (int)(side + 9), (int)(side - 6), (int)color);
        GlStateManager.func_179137_b((double)6.0, (double)6.0, (double)0.0);
        if (this.region == null) {
            GlStateManager.func_179121_F();
            return;
        }
        double mu = this.region.getMinX();
        double mv = this.region.getMinZ();
        double nu = this.region.getMaxX();
        double nv = this.region.getMaxZ();
        double su = (double)work / (nu - mu);
        double sv = (double)work / (nv - mv);
        double sy = (double)work / 255.0;
        if (this.region.size() >= 3) {
            this.drawRegion(work, mu, mv, su, sv, sy);
        }
        Point p = null;
        if (this.region.dimensionID == this.field_146297_k.field_71439_g.field_70170_p.field_73011_w.getDimension()) {
            p = this.region.points.get(this.region.getIdNearestPoint(this.field_146297_k.field_71439_g.func_180425_c()));
        }
        if (p != null) {
            hx = (int)(((double)p.x - mu) * su);
            hz = (int)(((double)p.y - mv) * sv);
            int d = this.point != null && this.point.x == p.x && this.point.y == p.y ? 1 : 0;
            Gui.func_73734_a((int)(hx - d - 1), (int)(hz - d - 1), (int)(hx + d + 1), (int)(hz + d + 1), (int)new Color(-16711936).getRGB());
        }
        if (this.point != null) {
            hx = (int)(((double)this.point.x - mu) * su);
            hz = (int)(((double)this.point.y - mv) * sv);
            Gui.func_73734_a((int)(hx - 1), (int)(hz - 1), (int)(hx + 1), (int)(hz + 1), (int)new Color(-256).getRGB());
        }
        if (this.region.homePos != null) {
            hx = (int)((this.region.homePos.getX() - mu) * su);
            hz = (int)((this.region.homePos.getZ() - mv) * sv);
            if (hx < 0) {
                hx = 0;
            } else if (hx > work) {
                hx = work;
            }
            if (hz < 0) {
                hz = 0;
            } else if (hz > work) {
                hz = work;
            }
            Gui.func_73734_a((int)(hx - 1), (int)(hz - 1), (int)hx, (int)hz, (int)new Color(-65536).getRGB());
        }
        IPos c = this.region.getCenter();
        hx = (int)((c.getX() - mu) * su);
        hz = (int)((c.getZ() - mv) * sv);
        Gui.func_73734_a((int)(hx - 1), (int)(hz - 1), (int)(hx + 1), (int)(hz + 1), (int)new Color(-16776961).getRGB());
        color = new Color(-1).getRGB();
        int xp = this.player.func_180425_c().func_177958_n();
        if ((double)xp < mu) {
            xp = (int)mu;
            color = new Color(-1593835521).getRGB();
        } else if ((double)xp > nu) {
            xp = (int)nu;
            color = new Color(-1593835521).getRGB();
        }
        hx = (int)(((double)xp - mu) * su);
        if (hx < 0) {
            hx = 0;
            color = new Color(-251658241).getRGB();
        } else if (hx > work) {
            hx = work;
            color = new Color(-251658241).getRGB();
        }
        int zp = this.player.func_180425_c().func_177952_p();
        if ((double)zp < mv) {
            zp = (int)mv;
            color = new Color(-251658241).getRGB();
        } else if ((double)zp > nv) {
            zp = (int)nv;
            color = new Color(-251658241).getRGB();
        }
        hz = (int)(((double)zp - mv) * sv);
        int d = (this.point != null && this.point.x == this.player.func_180425_c().func_177958_n() && this.point.y == this.player.func_180425_c().func_177952_p() ? 1 : 0) + 1;
        if (p != null && p.x == this.player.func_180425_c().func_177958_n() && p.y == this.player.func_180425_c().func_177952_p()) {
            ++d;
        }
        if (c.getX() == (double)this.player.func_180425_c().func_177958_n() && c.getZ() == (double)this.player.func_180425_c().func_177952_p()) {
            ++d;
        }
        Gui.func_73734_a((int)(hx - d - 1), (int)(hz - d - 1), (int)(hx + d + 1), (int)(hz + d + 1), (int)color);
        int hy = (int)((double)this.player.func_180425_c().func_177956_o() * sy);
        Gui.func_73734_a((int)(side - 6), (int)(side - hy - 13), (int)(side - 4), (int)(side - hy - 11), (int)new Color(-1).getRGB());
        GlStateManager.func_179121_F();
        if (this.subgui != null || !CustomNpcs.ShowDescriptions) {
            return;
        }
        if (!ht.isEmpty()) {
            this.drawHoverText(ht, new Object[0]);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.dataRegions.clear();
        this.dataPoints.clear();
        String selectReg = "";
        String selectP = "";
        int side = 186;
        int r0 = this.guiLeft + 118;
        int r1 = this.guiLeft + side + 119;
        int h0 = this.guiTop + 109;
        BorderController bData = BorderController.getInstance();
        if (this.region != null && !bData.regions.containsKey(this.region.getId())) {
            this.region = null;
            this.point = null;
        }
        if (this.region != null && this.point != null && !this.region.contains(this.point.x, this.point.y)) {
            this.point = null;
            if (!this.region.points.isEmpty()) {
                this.point = this.region.points.get(0);
            }
        }
        for (Zone3D reg : bData.regions.values()) {
            this.dataRegions.put(reg.getId(), reg.toString());
            if (this.regID != reg.getId()) continue;
            this.region = reg;
            selectReg = this.dataRegions.get(reg.getId());
            for (int id : reg.points.keySet()) {
                this.dataPoints.put(id, "ID: " + id + " [" + reg.points.get((Object)Integer.valueOf((int)id)).x + ", " + reg.points.get((Object)Integer.valueOf((int)id)).y + "]");
                if (this.point == null || this.point != reg.points.get(id) && (this.point.x != reg.points.get((Object)Integer.valueOf((int)id)).x || this.point.y != reg.points.get((Object)Integer.valueOf((int)id)).y)) continue;
                selectP = this.dataPoints.get(id);
            }
        }
        if (this.regions == null) {
            this.regions = new GuiCustomScroll(this, 0);
            this.regions.setSize(110, 130);
        }
        this.regions.setListNotSorted(new ArrayList<String>(this.dataRegions.values()));
        this.regions.guiLeft = this.guiLeft + 5;
        this.regions.guiTop = this.guiTop + 14;
        if (!selectReg.isEmpty()) {
            this.regions.setSelected(selectReg);
        }
        this.addScroll(this.regions);
        int gray = new Color(-14671840).getRGB();
        GuiNpcLabel label = new GuiNpcLabel(103, "gui.regions", this.guiLeft + 5, this.guiTop + 4, gray);
        label.setHoverText("region.hover.regions.list", new TextComponentTranslation("item.npcboundary.name", new Object[0]).func_150254_d());
        this.addLabel(label);
        if (this.points == null) {
            this.points = new GuiCustomScroll(this, 1);
            this.points.setSize(this.xSize - side - 124, side / 2);
        }
        this.points.setListNotSorted(new ArrayList<String>(this.dataPoints.values()));
        this.points.guiLeft = r1;
        this.points.guiTop = this.guiTop + 14;
        if (!selectP.isEmpty()) {
            this.points.setSelected(selectP);
        }
        this.addScroll(this.points);
        label = new GuiNpcLabel(104, "gui.points", r1, this.guiTop + 4, gray);
        label.setHoverText("region.hover.points.list", new TextComponentTranslation("item.npcboundary.name", new Object[0]).func_150254_d());
        this.addLabel(label);
        String color = "gui.color";
        if (this.region != null) {
            StringBuilder c = new StringBuilder(Integer.toHexString(this.region.color));
            while (c.length() < 6) {
                c.insert(0, "0");
            }
            color = c.toString();
        }
        GuiNpcButton button = new GuiNpcButton(0, this.guiLeft + 5, this.guiTop + 162, 60, 13, color);
        button.setEnabled(this.region != null);
        if (this.region != null) {
            button.setTextColor(this.region.color);
        }
        button.setHoverText("region.hover.color", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, this.guiLeft + 5, this.guiTop + 147, 110, 13, "availability.available");
        button.setEnabled(this.region != null);
        button.setHoverText("availability.hover", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + 67, this.guiTop + 162, 48, 13, "gui.remove");
        button.setEnabled(this.region != null);
        button.setHoverText("hover.delete", new Object[0]);
        this.addButton(button);
        String trRegion = new TextComponentTranslation("gui.region", new Object[0]).func_150254_d();
        button = new GuiNpcButton(3, r0 + 13, this.guiTop + 3, 13, 13, String.valueOf('\u25c4'));
        button.setEnabled(this.region != null);
        button.setHoverText("region.hover.offSet.-x", trRegion);
        this.addButton(button);
        button = new GuiNpcButton(4, r0 + 27, this.guiTop + 3, 13, 13, String.valueOf('\u25ba'));
        button.setEnabled(this.region != null);
        button.setHoverText("region.hover.offSet.+x", trRegion);
        this.addButton(button);
        button = new GuiNpcButton(5, r0 - 1, this.guiTop + 18, 13, 13, String.valueOf('\u25b2'));
        button.setEnabled(this.region != null);
        button.setHoverText("region.hover.offSet.-z", trRegion);
        this.addButton(button);
        button = new GuiNpcButton(6, r0 - 1, this.guiTop + 32, 13, 13, String.valueOf('\u25bc'));
        button.setEnabled(this.region != null);
        button.setHoverText("region.hover.offSet.+z", trRegion);
        this.addButton(button);
        button = new GuiNpcButton(7, r0 - 1, this.guiTop + side - 21, 13, 13, String.valueOf('\u25bc'));
        button.setEnabled(this.region != null);
        button.setHoverText("region.hover.offSet.-y", trRegion);
        this.addButton(button);
        button = new GuiNpcButton(8, r0 - 1, this.guiTop + side - 35, 13, 13, String.valueOf('\u25b2'));
        button.setEnabled(this.region != null);
        button.setHoverText("region.hover.offSet.+y", trRegion);
        this.addButton(button);
        button = new GuiNpcButton(10, r1, h0, 39, 13, String.valueOf('\u02c4'));
        button.setEnabled(this.region != null);
        button.setHoverText("region.hover.offSet.up", trRegion);
        this.addButton(button);
        button = new GuiNpcButton(11, r1 + 42, h0, 39, 13, String.valueOf('\u02c5'));
        button.setEnabled(this.region != null && this.point != null);
        button.setHoverText("region.hover.point.offSet.down", trRegion);
        this.addButton(button);
        String trPoint = new TextComponentTranslation("gui.point", new Object[0]).func_150254_d();
        button = new GuiNpcButton(12, r1, h0 + 27, 13, 13, String.valueOf('\u25c4'));
        button.setEnabled(this.region != null && this.point != null);
        button.setHoverText("region.hover.offSet.-x", trPoint);
        this.addButton(button);
        button = new GuiNpcButton(13, r1 + 24, h0 + 27, 13, 13, String.valueOf('\u25ba'));
        button.setEnabled(this.region != null && this.point != null);
        button.setHoverText("region.hover.offSet.+x", trPoint);
        this.addButton(button);
        button = new GuiNpcButton(14, r1 + 12, h0 + 14, 13, 13, String.valueOf('\u25b2'));
        button.setEnabled(this.region != null && this.point != null);
        button.setHoverText("region.hover.offSet.-z", trPoint);
        this.addButton(button);
        button = new GuiNpcButton(15, r1 + 12, h0 + 40, 13, 13, String.valueOf('\u25bc'));
        button.setEnabled(this.region != null && this.point != null);
        button.setHoverText("region.hover.offSet.+z", trPoint);
        this.addButton(button);
        button = new GuiNpcButton(18, r1, h0 + 55, 13, 13, String.valueOf('\u25b2'));
        button.setEnabled(this.region != null && this.point != null);
        button.setHoverText("region.hover.offSet.up.-y", trPoint);
        this.addButton(button);
        button = new GuiNpcButton(19, r1, h0 + 72, 13, 13, String.valueOf('\u25bc'));
        button.setEnabled(this.region != null && this.point != null);
        button.setHoverText("region.hover.offSet.up.+y", trPoint);
        this.addButton(button);
        button = new GuiNpcButton(20, r1 + 47, h0 + 55, 13, 13, String.valueOf('\u25b2'));
        button.setEnabled(this.region != null && this.point != null);
        button.setHoverText("region.hover.offSet.down.-y", trPoint);
        this.addButton(button);
        button = new GuiNpcButton(21, r1 + 47, h0 + 72, 13, 13, String.valueOf('\u25bc'));
        button.setEnabled(this.region != null && this.point != null);
        button.setHoverText("region.hover.offSet.down.+y", trPoint);
        this.addButton(button);
        button = new GuiNpcButton(24, r1 + 74, h0 + 23, 20, 20, "TP");
        button.setEnabled(this.region != null && this.point != null);
        button.setHoverText("hover.teleport", trPoint);
        this.addButton(button);
        GuiNpcCheckBox checkBox = new GuiNpcCheckBox(25, this.guiLeft + 5, this.guiTop + side + 9, 110, 12, "region.keepout.true", "region.keepout.false", this.region != null && this.region.keepOut);
        checkBox.setSelected(this.region != null && this.region.keepOut);
        checkBox.setHoverText("region.hover.keepout", new Object[0]);
        this.addButton(checkBox);
        checkBox = new GuiNpcCheckBox(26, this.guiLeft + 275, this.guiTop + side + 9, 110, 12, "region.show.in.client.true", "region.show.in.client.false", this.region != null && this.region.showInClient);
        checkBox.setSelected(this.region != null && this.region.showInClient);
        checkBox.setHoverText("region.hover.show.in.client", new Object[0]);
        this.addButton(checkBox);
        GuiNpcTextField textField = new GuiNpcTextField(16, this, r1 + 39, h0 + 17, 31, 15, "" + (this.point != null ? this.point.x : 0));
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.point != null ? (long)this.point.x : 0L);
        textField.func_146184_c(this.region != null && this.point != null);
        textField.setHoverText("X pos", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(17, this, r1 + 39, h0 + 33, 31, 15, "" + (this.point != null ? this.point.y : 0));
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.point != null ? (long)this.point.y : 0L);
        textField.func_146184_c(this.region != null && this.point != null);
        textField.setHoverText("Z pos", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(22, this, r1 + 14, h0 + 63, 31, 15, "" + (this.region != null ? this.region.y[1] : 0));
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.region != null ? (long)this.region.y[1] : 0L);
        textField.func_146184_c(this.region != null && this.point != null);
        textField.setHoverText("max Y", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(23, this, r1 + 61, h0 + 63, 31, 15, "" + (this.region != null ? this.region.y[0] : 0));
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.region != null ? (long)this.region.y[0] : 0L);
        textField.func_146184_c(this.region != null && this.point != null);
        textField.setHoverText("min Y", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(24, this, this.guiLeft + 5, this.guiTop + 178, 110, 15, this.region != null ? this.region.name : "");
        textField.func_146184_c(this.region != null && this.point != null);
        textField.setHoverText("region.hover.name", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(25, this, r0 + 39, this.guiTop + side + 11, 35, 13, "" + (this.region != null ? Double.valueOf(this.region.homePos.getX()) : ""));
        textField.func_146184_c(this.region != null && this.point != null);
        textField.setHoverText("region.hover.home.axis", "X");
        this.addTextField(textField);
        textField = new GuiNpcTextField(26, this, r0 + 77, this.guiTop + side + 11, 35, 13, "" + (this.region != null ? Double.valueOf(this.region.homePos.getY()) : ""));
        textField.func_146184_c(this.region != null && this.point != null);
        textField.setHoverText("region.hover.home.axis", "Y");
        this.addTextField(textField);
        textField = new GuiNpcTextField(27, this, r0 + 115, this.guiTop + side + 11, 35, 13, "" + (this.region != null ? Double.valueOf(this.region.homePos.getZ()) : ""));
        textField.func_146184_c(this.region != null && this.point != null);
        textField.setHoverText("region.hover.home.axis", "Z");
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(99, "Home POS:", r0, this.guiTop + side + 13, gray));
        this.addLabel(new GuiNpcLabel(100, "MinXZ: [" + (this.region == null ? "0, 0" : this.region.getMinX() + "," + this.region.getMinZ()) + "]", r0 + 47, this.guiTop + 6, gray));
        this.addLabel(new GuiNpcLabel(101, "MaxXZ: [" + (this.region == null ? "0, 0" : this.region.getMaxX() + "," + this.region.getMaxZ()) + "]", r0, this.guiTop + side - 3, gray));
        String text = "Min/Max Y: [" + (this.region == null ? "0, 0" : this.region.y[0] + "," + this.region.y[1]) + "]";
        this.addLabel(new GuiNpcLabel(102, text, r0 + side - this.field_146297_k.field_71466_p.func_78256_a(text) - 1, this.guiTop + side - 3, gray));
        text = "(worldID: " + (this.region == null ? "N/A" : Integer.valueOf(this.region.dimensionID)) + ")";
        this.addLabel(new GuiNpcLabel(105, text, r0 + side - this.field_146297_k.field_71466_p.func_78256_a(text) - 5, this.guiTop + 4, gray));
    }

    @Override
    public void save() {
        if (this.region != null) {
            NBTTagCompound regionNbt = new NBTTagCompound();
            this.region.save(regionNbt);
            Client.sendData(EnumPacketServer.RegionData, 2, regionNbt);
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int time, IGuiCustomScroll scroll) {
        block0 : switch (scroll.getID()) {
            case 0: {
                if (!this.dataRegions.containsValue(scroll.getSelected())) {
                    return;
                }
                BorderController bData = BorderController.getInstance();
                for (int id : this.dataRegions.keySet()) {
                    if (this.region != null && this.region.getId() == id || !this.dataRegions.get(id).equals(scroll.getSelected()) || !bData.regions.containsKey(id)) continue;
                    this.region = (Zone3D)bData.getRegion(id);
                    this.point = null;
                    if (!this.region.points.isEmpty()) {
                        this.point = this.region.points.get(0);
                    }
                    Client.sendData(EnumPacketServer.RegionData, 0, id);
                    this.func_73866_w_();
                    break block0;
                }
                break;
            }
            case 1: {
                if (this.region == null || !this.dataPoints.containsValue(scroll.getSelected())) {
                    return;
                }
                for (int id : this.dataPoints.keySet()) {
                    if (!this.dataPoints.get(id).equals(scroll.getSelected()) || !this.region.points.containsKey(id)) continue;
                    this.point = this.region.points.get(id);
                    this.func_73866_w_();
                    break block0;
                }
                break;
            }
        }
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        switch (scroll.getID()) {
            case 0: {
                if (this.region == null) {
                    return;
                }
                IPos pos = this.region.getCenter();
                Client.sendData(EnumPacketServer.TeleportTo, this.region.dimensionID, pos.getX(), pos.getY(), pos.getZ());
                Client.sendData(EnumPacketServer.RegionData, 0, this.region.getId());
                this.close();
                break;
            }
            case 1: {
                if (this.region == null || this.point == null) {
                    return;
                }
                Client.sendData(EnumPacketServer.TeleportTo, this.region.dimensionID, this.point.x, this.region.y[0] + (this.region.y[1] - this.region.y[0]) / 2, this.point.y);
                Client.sendData(EnumPacketServer.RegionData, 0, this.region.getId());
                this.close();
            }
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiColorSelector && this.region != null) {
            this.region.color = ((SubGuiColorSelector)subgui).color;
            this.func_73866_w_();
        }
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (textField.getFullText().isEmpty()) {
            return;
        }
        switch (textField.getID()) {
            case 16: {
                if (this.point == null || !textField.isInteger()) {
                    return;
                }
                this.point.x = textField.getInteger();
                this.func_73866_w_();
                break;
            }
            case 17: {
                if (this.point == null || !textField.isInteger()) {
                    return;
                }
                this.point.y = textField.getInteger();
                this.func_73866_w_();
                break;
            }
            case 22: {
                if (this.region == null || !textField.isInteger()) {
                    return;
                }
                this.region.y[1] = textField.getInteger();
                this.func_73866_w_();
                break;
            }
            case 23: {
                if (this.region == null || !textField.isInteger()) {
                    return;
                }
                this.region.y[0] = textField.getInteger();
                this.func_73866_w_();
                break;
            }
            case 24: {
                if (this.region == null) {
                    return;
                }
                this.region.name = textField.getFullText();
                break;
            }
            case 25: {
                if (this.region == null || !textField.isInteger()) {
                    return;
                }
                IPos pos = this.region.homePos;
                this.region.setHomePos(textField.getInteger(), (int)pos.getY(), (int)pos.getZ());
                break;
            }
            case 26: {
                if (this.region == null || !textField.isInteger()) {
                    return;
                }
                IPos pos = this.region.homePos;
                this.region.setHomePos((int)pos.getX(), textField.getInteger(), (int)pos.getZ());
                break;
            }
            case 27: {
                if (this.region == null || !textField.isInteger()) {
                    return;
                }
                IPos pos = this.region.homePos;
                this.region.setHomePos((int)pos.getX(), (int)pos.getY(), textField.getInteger());
                break;
            }
        }
    }
}

